//==============================================================================
// Project:		Wealth Transfers and their economic effects
// File name:	Figures B.5
// Objective: 	Generate the data underpinning figure B.5
//
//==============================================================================

clear all

************************
*** Data import ***
************************

cd "XXXX" //set content directory here

use combined_filtered_restricted.dta, replace

merge m:1 wave using CPI.dta //CPI data
drop if _merge == 2
drop _merge 

xtset xwaveid wave

************************
*** Create variables ***
************************

replace oifnptr = 0 if oifnptr == -10
replace oifnpt = 0 if oifnpt == -10
replace oifnptr = . if oifnptr < 0
gen gift = oifnptr + oifnpt
 
gen net_worth = hwnwip - hwnwin //household net worth

rename wlebf weight_2 //weights
rename wlefj weight_6
rename wlejn weight_10
rename wlenr weight_14
gen weight = weight_2 if wave == 2
replace weight = weight_6 if wave == 6
replace weight = weight_10 if wave == 10
replace weight = weight_14 if wave == 14

codebook weight if wave == 2 | wave == 6 | wave == 10 | wave == 14

gen child = 1 if hgage < 15 //generate equivalisation scale (OECD modified)
gen adult = 1 if hgage >= 15
egen total_child = total(child), by(hhrhid wave)
egen total_adult = total(adult), by(hhrhid wave)
gen equiv_scale = total_child*0.3 + total_adult*0.5 + 0.5 //0.3 for children, 1 for first adult and 0.5 for all subsequent adults

egen total_gift = total(gift), by(hhrhid wave)
gen gift_real = total_gift * 100 / (CPI) //real gifts

gen net_worth_real = net_worth * 100 / (CPI) //real net worth

gen net_worth_gift_real = net_worth_real + F2.gift_real + F3.gift_real + F4.gift_real

gen F2_4_gift_real = F2.gift_real + F3.gift_real + F4.gift_real

gen F2_4_gift_real_positive = 0
replace F2_4_gift_real_positive = 1 if F2_4_gift_real > 0 //flag for a gift

gen flag = 1

drop if net_worth_gift_real == . //drop cases where the person not in both waves, due to death or moving abroad (the weights don't adjust for this)

**************************
*** Calculate quintiles **
**************************

gen net_worth_quin_2 = .
local wealth_waves 2 6 10 14
foreach x of local wealth_waves{
    capture noisily xtile net_worth_quin_2_`x' = net_worth_real [pweight = weight_`x'] if wave == `x', nq(5)
	replace net_worth_quin_2 = net_worth_quin_2_`x' if wave == `x'
}

svyset [pweight = weight], // note that strata(xhhstrat) cannot be used because of stratum with single sampling unit
svy: mean F2_4_gift_real if (wave == 2 | wave == 6 | wave == 10 | wave == 14) & F2_4_gift_real > 0, over(net_worth_quin_2) //figure B.5, panel b
matrix mean_positive = r(table)'
svyset [pweight = weight], strata(xhhstrat) psu(xhhraid)
svy: ratio F2_4_gift_real_positive flag if (wave == 2 | wave == 6 | wave == 10 | wave == 14), over(net_worth_quin_2) //figure B.5, panel a
matrix share_positive = r(table)'
svy: mean F2_4_gift_real if (wave == 2 | wave == 6 | wave == 10 | wave == 14), over(net_worth_quin_2)  //figure B.5, panel c
matrix mean = r(table)'
svy: mean net_worth_real if (wave == 2 | wave == 6 | wave == 10 | wave == 14), over(net_worth_quin_2)
svy: ratio F2_4_gift_real net_worth_real if (wave == 2 | wave == 6 | wave == 10 | wave == 14), over(net_worth_quin_2) //figure B.5, panel d
matrix relative = r(table)'

************************************************
*** Quintiles for charting **
************************************************
clear

svmat mean_positive
rename mean_positive1 b_mean_positive
drop mean*
svmat mean_positive
gen b_mean_positive_95CI = mean_positive2 * 1.96
drop mean*
svmat share_positive
rename share_positive1 b_share_positive
replace b_share_positive = 100 * b_share_positive
drop share*
svmat share_positive
gen b_share_positive_95CI = 100 * share_positive2 * 1.96
drop share*
svmat mean
rename mean1 b_mean
drop mean*
svmat mean
gen b_mean_95CI = mean2 * 1.96
drop mean*
svmat relative
rename relative1 b_relative
replace b_relative = 100 * b_relative
drop relative*
svmat relative
gen b_relative_95CI = 100 * relative2 * 1.96
drop relative*

export delimited gift_quintiles_for_charting_pooled_3_HH.csv, replace




















